/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EventHooks;
import noppes.npcs.LogWriter;
import noppes.npcs.api.event.NpcEvent;
import noppes.npcs.constants.EnumScriptType;
import noppes.npcs.controllers.ScriptContainer;
import noppes.npcs.controllers.ScriptController;
import noppes.npcs.controllers.data.BaseScriptData;
import noppes.npcs.entity.EntityNPCInterface;

public class NpcScriptData
extends BaseScriptData {
    @Override
    public ITextComponent noticeString(String type, Object event) {
        TextComponentString message = new TextComponentString("NPC's Scripts ");
        message.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        if (type != null) {
            TextComponentString hook = new TextComponentString(" hook \"");
            hook.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString hookType = new TextComponentString(type);
            hookType.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString hookEnd = new TextComponentString("\"; ");
            hookEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)hook).func_150257_a((ITextComponent)hookType).func_150257_a((ITextComponent)hookEnd);
        }
        if (event instanceof NpcEvent && ((NpcEvent)((Object)event)).npc != null) {
            EntityNPCInterface npc = (EntityNPCInterface)((Object)((NpcEvent)((Object)event)).npc.getMCEntity());
            TextComponentString mesNpc = new TextComponentString("NPC \"");
            mesNpc.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString name = new TextComponentString(npc.func_70005_c_());
            name.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString mesUUID = new TextComponentString("\"; UUID: \"");
            mesUUID.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            TextComponentString uuid = new TextComponentString(npc.func_110124_au().toString());
            uuid.func_150256_b().func_150238_a(TextFormatting.GRAY);
            TextComponentString mesEnd = new TextComponentString("\" in ");
            mesEnd.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
            message = message.func_150257_a((ITextComponent)mesNpc).func_150257_a((ITextComponent)name).func_150257_a((ITextComponent)mesUUID).func_150257_a((ITextComponent)uuid).func_150257_a((ITextComponent)mesEnd);
            int dimID = npc.field_70170_p == null ? 0 : npc.field_70170_p.field_73011_w.getDimension();
            double x = (double)Math.round(npc.field_70165_t * 100.0) / 100.0;
            double y = (double)Math.round(npc.field_70163_u * 100.0) / 100.0;
            double z = (double)Math.round(npc.field_70161_v * 100.0) / 100.0;
            TextComponentString posClick = new TextComponentString("dimension ID:" + dimID + "; X:" + x + "; Y:" + y + "; Z:" + z);
            posClick.func_150256_b().func_150238_a(TextFormatting.BLUE).func_150228_d(Boolean.valueOf(true)).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/noppes world tp @p " + dimID + " " + x + " " + y + " " + z)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("script.hover.error.pos.tp", new Object[0])));
            message = message.func_150257_a((ITextComponent)posClick);
        }
        TextComponentString side = new TextComponentString("; Side: " + (this.isClient() ? "Client" : "Server"));
        side.func_150256_b().func_150238_a(TextFormatting.DARK_GRAY);
        return message.func_150257_a((ITextComponent)side);
    }

    @Override
    public void runScript(String type, Event event) {
        super.runScript(type, event);
        if (!this.isEnabled()) {
            return;
        }
        try {
            CustomNpcs.Server.func_152344_a(() -> {
                if (ScriptController.Instance.lastLoaded > this.lastInited) {
                    this.lastInited = ScriptController.Instance.lastLoaded;
                    if (!type.equalsIgnoreCase(EnumScriptType.INIT.function)) {
                        EventHooks.onNPCsInit(this);
                    }
                }
                for (ScriptContainer script : this.scripts) {
                    script.run(type, event);
                }
            });
        }
        catch (Exception e) {
            LogWriter.error(e);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        EventHooks.onNPCsInit(this);
    }
}

